/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.ValidationException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.Validator;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;

public class StringValidator
extends Validator {
    private static final String TRACE_MASKT = "XPMNVSTT";
    private static final String TRACE_MASKF = "XPMNVSTF";
    private int minLength = -1;
    private int maxLength = -1;
    private String characters = null;

    public void setMinLength(int minLength) {
        Trace.trace(TRACE_MASKF, "StringValidator.setMinLength(" + minLength + ")");
        this.minLength = minLength;
        if (minLength != -1 && this.maxLength != -1 && this.maxLength < minLength) {
            throw new RuntimeException("Max appears less than min");
        }
    }

    public void setMaxLength(int maxLength) {
        Trace.trace(TRACE_MASKF, "StringValidator.setMaxLength(" + maxLength + ")");
        this.maxLength = maxLength;
        if (this.minLength != -1 && maxLength != -1 && maxLength < this.minLength) {
            throw new RuntimeException("Max appears less than min");
        }
    }

    public void setCharacters(String characters) {
        Trace.trace(TRACE_MASKF, "StringValidator.setCharacters(" + characters + ")");
        this.characters = characters;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validate(Object value) throws ValidationException {
        Trace.trace(TRACE_MASKF, "StringValidator.validate(" + value + ")");
        if (value == null) {
            Trace.trace(TRACE_MASKF, "StringValidator.validate(" + value + ") accepted (null)");
            return;
        }
        if (!(value instanceof String)) {
            Trace.trace(TRACE_MASKF, "StringValidator.validate(" + value + ") rejected (!string)");
            throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "StringNotString"));
        }
        String string = (String)value;
        int strLength = string.length();
        if (this.minLength != -1 && strLength < this.minLength) {
            Trace.trace(TRACE_MASKF, "StringValidator.validate(" + value + ") rejected (under)");
            throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "StringToShort"));
        }
        if (this.maxLength != -1 && strLength > this.maxLength) {
            Trace.trace(TRACE_MASKF, "StringValidator.validate(" + value + ") rejected (over)");
            throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "StringToLong"));
        }
        if (this.characters != null) {
            char[] data = new char[strLength];
            string.getChars(0, strLength, data, 0);
            for (int i = 0; i < data.length; ++i) {
                if (this.characters.indexOf(data[i]) != -1) continue;
                Trace.trace(TRACE_MASKF, "StringValidator.validate(" + value + ") rejected (!in char set)");
                throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "StringBadChar", new Object[]{new String(new char[]{data[i]})}));
            }
        }
        Trace.trace(TRACE_MASKF, "StringValidator.validate(" + value + ") accepted");
    }
}

